/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.mecab_ko_lucene_analyzer;

import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosIdManager;
import org.chasen.mecab.Node;

public class Pos {
    private String surface;
    private String semanticClass;
    private String pos;
    private PosIdManager.PosId posId;
    private PosIdManager.PosId startPosId;
    private PosIdManager.PosId endPosId;
    private int startOffset;
    private int positionIncr;
    private int positionLength;
    private String expression;
    private Node node;

    public Pos(String surface, PosIdManager.PosId posId, int startOffset, int positionIncr, int positionLength) {
        this.surface = surface;
        this.posId = posId;
        this.startPosId = posId;
        this.endPosId = posId;
        this.startOffset = startOffset;
        this.positionIncr = positionIncr;
        this.positionLength = positionLength;
    }

    public Pos(Node node, int prevEndOffset) {
        this(node.getSurface(), PosIdManager.PosId.convertFrom(node.getPosid()), prevEndOffset + node.getRlength() - node.getLength(), 1, 1);
        this.node = node;
        this.parseFeatureString();
    }

    public Pos(String expression, int startOffset) {
        try {
            String[] datas = expression.split("/");
            this.surface = datas[0];
            this.posId = PosIdManager.PosId.convertFrom(datas[1]);
            this.pos = datas[1];
            this.semanticClass = Pos.convertSemanticClass(datas[2]);
            this.startPosId = this.posId;
            this.endPosId = this.posId;
            this.startOffset = startOffset;
            this.positionIncr = 1;
            this.positionLength = 1;
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Use mecab-ko-dic 2.0.0 or higher.");
        }
    }

    private void parseFeatureString() {
        String feature = this.node.getFeature();
        String[] features = this.node.getFeature().split(",");
        this.pos = features[0];
        this.semanticClass = Pos.convertSemanticClass(features[1]);
        String[] items = feature.split(",");
        if (this.posId == PosIdManager.PosId.INFLECT || this.posId == PosIdManager.PosId.PREANALYSIS) {
            this.startPosId = PosIdManager.PosId.convertFrom(items[5].toUpperCase());
            this.endPosId = PosIdManager.PosId.convertFrom(items[6].toUpperCase());
            this.expression = items[7];
        } else if (this.posId == PosIdManager.PosId.COMPOUND) {
            this.startPosId = PosIdManager.PosId.NNG;
            this.endPosId = PosIdManager.PosId.NNG;
            this.positionLength = this.getCompoundNounPositionLength(items[7]);
            this.expression = items[7];
        } else {
            this.startPosId = this.posId;
            this.endPosId = this.posId;
        }
    }

    private int getCompoundNounPositionLength(String indexExpression) {
        String[] tokens = indexExpression.split("\\+");
        return tokens.length;
    }

    public Pos append(Pos pos, PosIdManager.PosId posId, int positionIncr) {
        return new Pos(this.getSurface() + pos.getSurface(), posId, this.getStartOffset(), positionIncr, this.getPositionLength() + pos.getPositionLength());
    }

    public boolean equalsOffset(Pos pos) {
        return this.getStartOffset() == pos.getStartOffset() && this.getEndOffset() == pos.getEndOffset();
    }

    public Node getNode() {
        return this.node;
    }

    public PosIdManager.PosId getPosId() {
        return this.posId;
    }

    public PosIdManager.PosId getStartPosId() {
        return this.startPosId;
    }

    public PosIdManager.PosId getEndPosId() {
        return this.endPosId;
    }

    public String getSurface() {
        return this.surface;
    }

    public String getTokenString() {
        switch (this.posId) {
            case VV: 
            case VA: {
                return this.surface + '/' + this.posId.toString();
            }
        }
        return this.surface;
    }

    public int getSurfaceLength() {
        return this.surface.length();
    }

    public String getMophemes() {
        return this.pos;
    }

    public String getSemanticClass() {
        return this.semanticClass;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.surface.length();
    }

    public int getPositionIncr() {
        return this.positionIncr;
    }

    public int getPositionLength() {
        return this.positionLength;
    }

    public int getSpaceLength() {
        if (this.node == null) {
            return 0;
        }
        return this.node.getRlength() - this.node.getLength();
    }

    public int getLength() {
        return this.getSpaceLength() + this.getSurfaceLength();
    }

    public boolean isPosIdOf(PosIdManager.PosId posId) {
        return this.posId == posId;
    }

    public boolean hasSpace() {
        return this.getSpaceLength() > 0;
    }

    public void setStartOffset(int val) {
        this.startOffset = val;
    }

    public void setPositionIncr(int val) {
        this.positionIncr = val;
    }

    public void setPositionLength(int val) {
        this.positionLength = val;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public String toString() {
        return new String(this.surface + "/" + (Object)((Object)this.posId) + "/" + this.semanticClass + "/" + this.positionIncr + "/" + this.positionLength + "/" + this.getStartOffset() + "/" + this.getEndOffset());
    }

    private static String convertSemanticClass(String semanticClass) {
        return semanticClass.equals("*") ? null : semanticClass;
    }

    public static class NodeIndex {
        static final int POS = 0;
        static final int SEMANTIC_CLASS = 1;
        static final int TYPE = 4;
        static final int START_POS = 5;
        static final int END_POS = 6;
        static final int EXPRESSION = 7;
    }

    public static class ExpressionIndex {
        static final int TERM = 0;
        static final int TAG = 1;
        static final int SEMANTIC_CLASS = 2;
    }
}

