/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.mecab_ko_lucene_analyzer;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Appendable;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Eojeol;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Pos;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosAppender;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosIdManager;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.TokenizerOption;

public class KeywordSearchPosAppender
extends PosAppender {
    public static Set<Appendable> appendableSet = new HashSet<Appendable>();

    public KeywordSearchPosAppender(TokenizerOption option) {
        super(option);
    }

    @Override
    public boolean isAppendable(Pos left, Pos right) {
        if (right.getNode() != null && right.hasSpace()) {
            return false;
        }
        if (left.getPosId() == PosIdManager.PosId.INFLECT && left.getStartPosId() != PosIdManager.PosId.VA && left.getStartPosId() != PosIdManager.PosId.VV) {
            return false;
        }
        return appendableSet.contains(new Appendable(left.getEndPosId(), right.getStartPosId()));
    }

    @Override
    public boolean isSkippablePos(Pos pos) {
        PosIdManager.PosId posId = pos.getPosId();
        switch (posId) {
            case COMPOUND: 
            case NNG: 
            case NNP: 
            case NNB: 
            case NNBC: 
            case NP: 
            case NR: 
            case SL: 
            case SH: 
            case SN: 
            case XR: {
                return false;
            }
            case INFLECT: {
                return pos.getStartPosId() != PosIdManager.PosId.VA && pos.getStartPosId() != PosIdManager.PosId.VV;
            }
        }
        return true;
    }

    @Override
    public LinkedList<Pos> getTokensFrom(Eojeol eojeol) {
        LinkedList<Pos> output = new LinkedList<Pos>();
        LinkedList<Pos> poses = eojeol.getPosList();
        if (poses.size() == 1) {
            output.add(poses.getFirst());
        } else {
            Pos eojeolPos = new Pos(eojeol.getTerm(), PosIdManager.PosId.EOJEOL, eojeol.getStartOffset(), 1, 1);
            output.add(eojeolPos);
        }
        return output;
    }

    private boolean isAbsolutePos(Pos pos) {
        return false;
    }

    static {
        appendableSet.add(new Appendable(PosIdManager.PosId.E, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VV, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VA, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.VX, PosIdManager.PosId.E));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNG, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNP, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNB, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.NNBC, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.NP, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.NR, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.COMPOUND, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.UNKNOWN, PosIdManager.PosId.XSN));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NNG));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NNP));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NNB));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NNBC));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NP));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.NR));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.COMPOUND));
        appendableSet.add(new Appendable(PosIdManager.PosId.XPN, PosIdManager.PosId.UNKNOWN));
    }
}

