/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.mecab_ko_lucene_analyzer;

import java.util.LinkedList;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.Pos;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosAppender;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosIdManager;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.TokenGenerator;

class Eojeol {
    private PosAppender appender;
    private int compoundNounMinLength;
    private boolean hasCompoundNoun;
    private LinkedList<Pos> posList = new LinkedList();
    private String term = "";

    Eojeol(PosAppender appender, int compoundNounMinLength) {
        this.appender = appender;
        this.compoundNounMinLength = compoundNounMinLength;
        this.hasCompoundNoun = false;
    }

    public boolean append(Pos pos) {
        if (this.isAppendable(pos)) {
            if (pos.isPosIdOf(PosIdManager.PosId.COMPOUND) && pos.getSurfaceLength() >= this.compoundNounMinLength) {
                this.hasCompoundNoun = true;
                this.posList.addAll(TokenGenerator.getAnalyzedPoses(pos));
            } else {
                this.posList.add(pos);
            }
            this.term = this.term + pos.getSurface();
            return true;
        }
        return false;
    }

    private boolean isAppendable(Pos pos) {
        return this.posList.isEmpty() || this.appender.isAppendable(this.posList.getLast(), pos);
    }

    public LinkedList<Pos> generateTokens() {
        if (this.isSkippable()) {
            return null;
        }
        return this.appender.getTokensFrom(this);
    }

    public boolean isSkippable() {
        return this.posList.isEmpty() || this.posList.size() == 1 && this.appender.isSkippablePos(this.posList.get(0));
    }

    public int getNumPoses() {
        return this.posList.size();
    }

    public Pos getPos(int index) {
        return this.posList.get(index);
    }

    public LinkedList<Pos> getPosList() {
        return this.posList;
    }

    public String getTerm() {
        return this.term;
    }

    public int getStartOffset() {
        return this.posList.getFirst().getStartOffset();
    }

    public boolean hasCompoundNoun() {
        return this.hasCompoundNoun;
    }

    public void setToCompoundNoun() {
        this.hasCompoundNoun = true;
    }

    public void clear() {
        this.posList.clear();
        this.term = "";
    }

    public String toString() {
        return this.posList.toString();
    }
}

