/*
 * Decompiled with CFR 0.152.
 */
package org.bitbucket.eunjeon.elasticsearch.index.analysis;

import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Tokenizer;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.MeCabKoTokenizer;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.PosAppender;
import org.bitbucket.eunjeon.mecab_ko_lucene_analyzer.TokenizerOption;
import org.bitbucket.eunjeon.mecab_ko_mecab_loader.MeCabLoader;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public abstract class MeCabKoTokenizerFactoryBase
extends AbstractTokenizerFactory {
    protected PosAppender posAppender;
    protected TokenizerOption option;
    private Logger logger = ESLoggerFactory.getLogger((String)"mecab-ko", MeCabKoTokenizerFactoryBase.class);

    public MeCabKoTokenizerFactoryBase(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.option = new TokenizerOption();
        this.setDefaultOption();
        this.setMeCabArgs(settings);
        this.setCompoundNounMinLength(settings);
        this.setUseAdjectiveAndVerbOriginalForm(settings);
        this.setPosAppender();
    }

    protected void setDefaultOption() {
    }

    protected abstract void setPosAppender();

    protected void setMeCabArgs(Settings settings) {
        this.option.mecabArgs = settings.get("mecab_args", this.option.mecabArgs);
    }

    protected void setCompoundNounMinLength(Settings settings) {
        this.option.compoundNounMinLength = settings.getAsInt("compound_noun_min_length", Integer.valueOf(this.option.compoundNounMinLength));
    }

    protected void setUseAdjectiveAndVerbOriginalForm(Settings settings) {
        this.option.useAdjectiveAndVerbOriginalForm = settings.getAsBoolean("use_adjective_and_verb_original_form", Boolean.valueOf(this.option.useAdjectiveAndVerbOriginalForm));
    }

    public Tokenizer create() {
        this.logger.debug("already allocated model's count is #" + MeCabLoader.getModelCount());
        this.logger.debug("creating tokenizer from model " + this.option.mecabArgs);
        return new MeCabKoTokenizer(this.option, this.posAppender);
    }
}

