/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hex {
    private static final Constructor<String> stringConstructor = Hex.getProtectedConstructor(String.class, Integer.TYPE, Integer.TYPE, char[].class);
    private static final byte[] charToByte = new byte[256];
    private static final Logger logger = LoggerFactory.getLogger(Hex.class);
    static final char[] byteToChar = new char[16];

    public static byte[] hexToBytes(String str) {
        if (str.length() % 2 == 1) {
            throw new NumberFormatException("An hex string representing bytes must have an even length");
        }
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte halfByte1 = charToByte[str.charAt(i * 2)];
            byte halfByte2 = charToByte[str.charAt(i * 2 + 1)];
            if (halfByte1 == -1 || halfByte2 == -1) {
                throw new NumberFormatException("Non-hex characters in " + str);
            }
            bytes[i] = (byte)(halfByte1 << 4 | halfByte2);
        }
        return bytes;
    }

    public static String bytesToHex(byte ... bytes) {
        return Hex.bytesToHex(bytes, 0, bytes.length);
    }

    public static String bytesToHex(byte[] bytes, int offset, int length) {
        char[] c = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            byte bint = bytes[i + offset];
            c[i * 2] = byteToChar[(bint & 0xF0) >> 4];
            c[1 + i * 2] = byteToChar[bint & 0xF];
        }
        return Hex.wrapCharArray(c);
    }

    public static String wrapCharArray(char[] c) {
        if (c == null) {
            return null;
        }
        String s = null;
        if (stringConstructor != null) {
            try {
                s = stringConstructor.newInstance(0, c.length, c);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                logger.error("Underlying string constructor threw an error: {}", (Object)(cause == null ? ite.getMessage() : cause.getMessage()));
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable((Throwable)e);
            }
        }
        return s == null ? new String(c) : s;
    }

    public static <T> Constructor<T> getProtectedConstructor(Class<T> klass, Class<?> ... paramTypes) {
        try {
            Constructor<T> c = klass.getDeclaredConstructor(paramTypes);
            c.setAccessible(true);
            return c;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        for (int c = 0; c < charToByte.length; c = (int)((char)(c + 1))) {
            Hex.charToByte[c] = c >= 48 && c <= 57 ? (int)(c - 48) : (c >= 65 && c <= 70 ? (int)(c - 65 + 10) : (c >= 97 && c <= 102 ? (int)(c - 97 + 10) : -1));
        }
        for (int i = 0; i < 16; ++i) {
            Hex.byteToChar[i] = Integer.toHexString(i).charAt(0);
        }
    }
}

