/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.base.Charsets;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ChecksumType;
import org.apache.cassandra.utils.Throwables;

public class DataIntegrityMetadata {
    public static ChecksumValidator checksumValidator(Descriptor desc) throws IOException {
        return new ChecksumValidator(desc);
    }

    public static FileDigestValidator fileDigestValidator(Descriptor desc) throws IOException {
        return new FileDigestValidator(desc);
    }

    public static class ChecksumWriter {
        private final CRC32 incrementalChecksum = new CRC32();
        private final DataOutput incrementalOut;
        private final CRC32 fullChecksum = new CRC32();

        public ChecksumWriter(DataOutput incrementalOut) {
            this.incrementalOut = incrementalOut;
        }

        public void writeChunkSize(int length) {
            try {
                this.incrementalOut.writeInt(length);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        public void appendDirect(ByteBuffer bb, boolean checksumIncrementalResult) {
            try {
                ByteBuffer toAppend = bb.duplicate();
                toAppend.mark();
                this.incrementalChecksum.update(toAppend);
                toAppend.reset();
                int incrementalChecksumValue = (int)this.incrementalChecksum.getValue();
                this.incrementalOut.writeInt(incrementalChecksumValue);
                this.fullChecksum.update(toAppend);
                if (checksumIncrementalResult) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                    byteBuffer.putInt(incrementalChecksumValue);
                    assert (byteBuffer.arrayOffset() == 0);
                    this.fullChecksum.update(byteBuffer.array(), 0, byteBuffer.array().length);
                }
                this.incrementalChecksum.reset();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        public void writeFullChecksum(Descriptor descriptor) {
            if (descriptor.digestComponent == null) {
                throw new NullPointerException("Null digest component for " + descriptor.ksname + '.' + descriptor.cfname + " file " + descriptor.baseFilename());
            }
            File outFile = new File(descriptor.filenameFor(descriptor.digestComponent));
            try (BufferedWriter out = Files.newBufferedWriter(outFile.toPath(), Charsets.UTF_8, new OpenOption[0]);){
                out.write(String.valueOf(this.fullChecksum.getValue()));
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, outFile);
            }
        }
    }

    public static class FileDigestValidator
    implements Closeable {
        private final Checksum checksum;
        private final RandomAccessReader digestReader;
        private final RandomAccessReader dataReader;
        private final Descriptor descriptor;
        private long storedDigestValue;

        public FileDigestValidator(Descriptor descriptor) throws IOException {
            this.descriptor = descriptor;
            this.checksum = descriptor.version.uncompressedChecksumType().newInstance();
            this.digestReader = RandomAccessReader.open(new File(descriptor.filenameFor(Component.digestFor((ChecksumType)descriptor.version.uncompressedChecksumType()))));
            this.dataReader = RandomAccessReader.open(new File(descriptor.filenameFor(Component.DATA)));
            try {
                this.storedDigestValue = Long.parseLong(this.digestReader.readLine());
            }
            catch (Exception e) {
                this.close();
                throw new IOException("Corrupted SSTable : " + descriptor.filenameFor(Component.DATA));
            }
        }

        public void validate() throws IOException {
            CheckedInputStream checkedInputStream = new CheckedInputStream(this.dataReader, this.checksum);
            byte[] chunk = new byte[65536];
            while (checkedInputStream.read(chunk) > 0) {
            }
            long calculatedDigestValue = checkedInputStream.getChecksum().getValue();
            if (this.storedDigestValue != calculatedDigestValue) {
                throw new IOException("Corrupted SSTable : " + this.descriptor.filenameFor(Component.DATA));
            }
        }

        @Override
        public void close() {
            Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[2];
            discreteActionArray[0] = this.digestReader::close;
            discreteActionArray[1] = this.dataReader::close;
            Throwables.perform((Throwables.DiscreteAction[])discreteActionArray);
        }
    }

    public static class ChecksumValidator
    implements Closeable {
        private final Checksum checksum;
        private final RandomAccessReader reader;
        public final int chunkSize;
        private final String dataFilename;

        public ChecksumValidator(Descriptor descriptor) throws IOException {
            this(descriptor.version.uncompressedChecksumType().newInstance(), RandomAccessReader.open(new File(descriptor.filenameFor(Component.CRC))), descriptor.filenameFor(Component.DATA));
        }

        public ChecksumValidator(Checksum checksum, RandomAccessReader reader, String dataFilename) throws IOException {
            this.checksum = checksum;
            this.reader = reader;
            this.dataFilename = dataFilename;
            this.chunkSize = reader.readInt();
        }

        public void seek(long offset) {
            long start = this.chunkStart(offset);
            this.reader.seek(start / (long)this.chunkSize * 4L + 4L);
        }

        public long chunkStart(long offset) {
            long startChunk = offset / (long)this.chunkSize;
            return startChunk * (long)this.chunkSize;
        }

        public void validate(byte[] bytes, int start, int end) throws IOException {
            this.checksum.update(bytes, start, end);
            int current = (int)this.checksum.getValue();
            this.checksum.reset();
            int actual = this.reader.readInt();
            if (current != actual) {
                throw new IOException("Corrupted File : " + this.dataFilename);
            }
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }
}

