/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeParser;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UnresolvedUserType;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UserType
extends DataType
implements Iterable<Field> {
    private static final String TYPE_NAME = "type_name";
    private static final String COLS_NAMES = "field_names";
    private static final String COLS_TYPES = "field_types";
    private final String keyspace;
    private final String typeName;
    private final ProtocolVersion protocolVersion;
    private volatile CodecRegistry codecRegistry;
    private final Field[] byIdx;
    private final Map<String, int[]> byName;

    UserType(String keyspace, String typeName, Collection<Field> fields, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        super(DataType.Name.UDT);
        this.keyspace = keyspace;
        this.typeName = typeName;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.byIdx = fields.toArray(new Field[fields.size()]);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (int i = 0; i < this.byIdx.length; ++i) {
            builder.put((Object)this.byIdx[i].getName(), (Object)new int[]{i});
        }
        this.byName = builder.build();
    }

    static UserType build(KeyspaceMetadata ksm, Row row, VersionNumber version, Cluster cluster, Map<String, UserType> userTypes) {
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        String keyspace = row.getString("keyspace_name");
        String name = row.getString(TYPE_NAME);
        List<String> fieldNames = row.getList(COLS_NAMES, String.class);
        List<String> fieldTypes = row.getList(COLS_TYPES, String.class);
        ArrayList<Field> fields = new ArrayList<Field>(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            DataType fieldType = (double)version.getMajor() >= 3.0 ? DataTypeParser.parse(fieldTypes.get(i), cluster, ksm, userTypes, false) : CassandraTypeParser.parseOne(fieldTypes.get(i), protocolVersion, codecRegistry);
            fields.add(new Field(fieldNames.get(i), fieldType));
        }
        return new UserType(keyspace, name, fields, protocolVersion, codecRegistry);
    }

    public UDTValue newValue() {
        return new UDTValue(this);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int size() {
        return this.byIdx.length;
    }

    public boolean contains(String name) {
        return this.byName.containsKey(Metadata.handleId(name));
    }

    @Override
    public Iterator<Field> iterator() {
        return Iterators.forArray((Object[])this.byIdx);
    }

    public Collection<String> getFieldNames() {
        return this.byName.keySet();
    }

    public DataType getFieldType(String name) {
        int[] idx = this.byName.get(Metadata.handleId(name));
        if (idx == null) {
            throw new IllegalArgumentException(name + " is not a field defined in this definition");
        }
        return this.byIdx[idx[0]].getType();
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    Field[] getFields() {
        return this.byIdx;
    }

    Map<String, int[]> getFieldIndicesByName() {
        return this.byName;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.keyspace.hashCode();
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + Arrays.hashCode(this.byIdx);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)o;
        return this.name.equals((Object)other.name) && this.keyspace.equals(other.keyspace) && this.typeName.equals(other.typeName) && Arrays.equals(this.getFields(), other.getFields());
    }

    public String exportAsString() {
        return this.asCQLQuery(true);
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    void setCodecRegistry(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TYPE ").append(Metadata.escapeId(this.keyspace)).append('.').append(Metadata.escapeId(this.typeName)).append(" (");
        TableMetadata.newLine(sb, formatted);
        for (int i = 0; i < this.byIdx.length; ++i) {
            sb.append(TableMetadata.spaces(4, formatted)).append(this.byIdx[i]);
            if (i < this.byIdx.length - 1) {
                sb.append(',');
            }
            TableMetadata.newLine(sb, formatted);
        }
        return sb.append(");").toString();
    }

    public String toString() {
        return "frozen<" + Metadata.escapeId(this.getKeyspace()) + '.' + Metadata.escapeId(this.getTypeName()) + ">";
    }

    public static class Field {
        private final String name;
        private final DataType type;

        Field(String name, DataType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.type});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }

        public String toString() {
            return Metadata.escapeId(this.name) + ' ' + this.type;
        }
    }

    static class UserTypeDependencyGraph
    implements Iterable<Row> {
        private final List<Row> rows;
        private final Cluster cluster;
        private final KeyspaceMetadata keyspace;

        UserTypeDependencyGraph(List<Row> rows, Cluster cluster, KeyspaceMetadata keyspace) {
            this.rows = rows;
            this.cluster = cluster;
            this.keyspace = keyspace;
        }

        @Override
        public Iterator<Row> iterator() {
            Vertex[] vertices = new Vertex[this.rows.size()];
            ArrayList<Edge> edges = new ArrayList<Edge>();
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = new Vertex(this.rows.get(i));
            }
            for (Vertex from : vertices) {
                for (Vertex to : vertices) {
                    if (from == to || !this.dependsOn(to.row, from.row)) continue;
                    edges.add(new Edge(from, to));
                }
            }
            for (Edge edge : edges) {
                ++edge.to.refCount;
            }
            LinkedList<Vertex> queue = new LinkedList<Vertex>();
            for (Vertex vertex : vertices) {
                if (vertex.refCount != 0) continue;
                queue.add(vertex);
            }
            Object[] rows = new Row[vertices.length];
            int i = 0;
            while (!queue.isEmpty()) {
                Vertex v = (Vertex)queue.remove();
                rows[i++] = v.row;
                for (Edge edge : edges) {
                    if (edge.from != v || --edge.to.refCount != 0) continue;
                    queue.add(edge.to);
                }
            }
            return Iterators.forArray((Object[])rows);
        }

        boolean dependsOn(Row udt1, Row udt2) {
            List<String> fieldTypes = udt1.getList(UserType.COLS_TYPES, String.class);
            String typeName = Metadata.escapeId(udt2.getString(UserType.TYPE_NAME));
            for (String fieldTypeStr : fieldTypes) {
                DataType fieldType = DataTypeParser.parse(fieldTypeStr, this.cluster, this.keyspace, null, false);
                if (!this.references(fieldType, typeName)) continue;
                return true;
            }
            return false;
        }

        boolean references(DataType dataType, String typeName) {
            if (dataType instanceof UserType) {
                assert (dataType instanceof UnresolvedUserType);
                if (typeName.equals(((UserType)dataType).getTypeName())) {
                    return true;
                }
            }
            for (DataType arg : dataType.getTypeArguments()) {
                if (!this.references(arg, typeName)) continue;
                return true;
            }
            if (dataType instanceof TupleType) {
                for (DataType arg : ((TupleType)dataType).getComponentTypes()) {
                    if (!this.references(arg, typeName)) continue;
                    return true;
                }
            }
            return false;
        }

        static class Edge {
            final Vertex from;
            final Vertex to;

            public Edge(Vertex from, Vertex to) {
                this.from = from;
                this.to = to;
            }
        }

        static class Vertex {
            int refCount = 0;
            final Row row;

            public Vertex(Row row) {
                this.row = row;
            }
        }
    }
}

