/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.UnresolvedUserTypeException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

class UnresolvedUserType
extends UserType {
    private final KeyspaceMetadata keyspace;
    private final AtomicReference<UserType> resolved = new AtomicReference<Object>(null);

    UnresolvedUserType(KeyspaceMetadata keyspace, String typeName, Cluster cluster) {
        super(keyspace.getName(), typeName, Collections.<UserType.Field>emptyList(), cluster.getConfiguration().getProtocolOptions().getProtocolVersion(), cluster.getConfiguration().getCodecRegistry());
        this.keyspace = keyspace;
    }

    @Override
    public int size() {
        this.resolve();
        return this.resolved.get().size();
    }

    @Override
    public boolean contains(String name) {
        this.resolve();
        return this.resolved.get().contains(name);
    }

    @Override
    public Iterator<UserType.Field> iterator() {
        this.resolve();
        return this.resolved.get().iterator();
    }

    @Override
    public Collection<String> getFieldNames() {
        this.resolve();
        return this.resolved.get().getFieldNames();
    }

    @Override
    public DataType getFieldType(String name) {
        this.resolve();
        return this.resolved.get().getFieldType(name);
    }

    @Override
    public String exportAsString() {
        this.resolve();
        return this.resolved.get().exportAsString();
    }

    @Override
    public String asCQLQuery() {
        this.resolve();
        return this.resolved.get().asCQLQuery();
    }

    @Override
    public int hashCode() {
        this.resolve();
        return this.resolved.get().hashCode();
    }

    @Override
    UserType.Field[] getFields() {
        this.resolve();
        return this.resolved.get().getFields();
    }

    @Override
    Map<String, int[]> getFieldIndicesByName() {
        this.resolve();
        return this.resolved.get().getFieldIndicesByName();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        this.resolve();
        return this.resolved.get().equals(o);
    }

    private void resolve() {
        if (this.resolved.get() == null) {
            UserType userType = this.keyspace.getUserType(this.getTypeName());
            if (userType == null) {
                throw new UnresolvedUserTypeException(Metadata.escapeId(this.keyspace.getName()), Metadata.escapeId(this.getTypeName()));
            }
            this.resolved.compareAndSet(null, userType);
        }
    }
}

