/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.UnresolvedUserType;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class DataTypeParser {
    private static final String FROZEN = "frozen";
    private static final String LIST = "list";
    private static final String SET = "set";
    private static final String MAP = "map";
    private static final String TUPLE = "tuple";
    private static final String EMPTY = "empty";
    private static final ImmutableMap<String, DataType> NATIVE_TYPES_MAP = new ImmutableMap.Builder().put((Object)"ascii", (Object)DataType.ascii()).put((Object)"bigint", (Object)DataType.bigint()).put((Object)"blob", (Object)DataType.blob()).put((Object)"boolean", (Object)DataType.cboolean()).put((Object)"counter", (Object)DataType.counter()).put((Object)"decimal", (Object)DataType.decimal()).put((Object)"double", (Object)DataType.cdouble()).put((Object)"float", (Object)DataType.cfloat()).put((Object)"inet", (Object)DataType.inet()).put((Object)"int", (Object)DataType.cint()).put((Object)"text", (Object)DataType.text()).put((Object)"varchar", (Object)DataType.varchar()).put((Object)"timestamp", (Object)DataType.timestamp()).put((Object)"date", (Object)DataType.date()).put((Object)"time", (Object)DataType.time()).put((Object)"uuid", (Object)DataType.uuid()).put((Object)"varint", (Object)DataType.varint()).put((Object)"timeuuid", (Object)DataType.timeuuid()).put((Object)"tinyint", (Object)DataType.tinyint()).put((Object)"smallint", (Object)DataType.smallint()).build();

    DataTypeParser() {
    }

    static DataType parse(String toParse, Cluster cluster, KeyspaceMetadata keyspace, Map<String, UserType> userTypes, boolean frozen) {
        UserType userType;
        Parser parser = new Parser(toParse, 0);
        String type = parser.parseTypeName();
        DataType nativeType = (DataType)NATIVE_TYPES_MAP.get((Object)type.toLowerCase());
        if (nativeType != null) {
            return nativeType;
        }
        if (type.equalsIgnoreCase(LIST)) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new DriverInternalError(String.format("Excepting single parameter for list, got %s", parameters));
            }
            DataType elementType = DataTypeParser.parse(parameters.get(0), cluster, keyspace, userTypes, false);
            return DataType.list(elementType, frozen);
        }
        if (type.equalsIgnoreCase(SET)) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new DriverInternalError(String.format("Excepting single parameter for set, got %s", parameters));
            }
            DataType elementType = DataTypeParser.parse(parameters.get(0), cluster, keyspace, userTypes, false);
            return DataType.set(elementType, frozen);
        }
        if (type.equalsIgnoreCase(MAP)) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 2) {
                throw new DriverInternalError(String.format("Excepting two parameters for map, got %s", parameters));
            }
            DataType keyType = DataTypeParser.parse(parameters.get(0), cluster, keyspace, userTypes, false);
            DataType valueType = DataTypeParser.parse(parameters.get(1), cluster, keyspace, userTypes, false);
            return DataType.map(keyType, valueType, frozen);
        }
        if (type.equalsIgnoreCase(FROZEN)) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new DriverInternalError(String.format("Excepting single parameter for frozen keyword, got %s", parameters));
            }
            return DataTypeParser.parse(parameters.get(0), cluster, keyspace, userTypes, true);
        }
        if (type.equalsIgnoreCase(TUPLE)) {
            List<String> rawTypes = parser.parseTypeParameters();
            ArrayList<DataType> types = new ArrayList<DataType>(rawTypes.size());
            for (String rawType : rawTypes) {
                types.add(DataTypeParser.parse(rawType, cluster, keyspace, userTypes, false));
            }
            return cluster.getMetadata().newTupleType(types);
        }
        if (type.equalsIgnoreCase(EMPTY)) {
            return DataType.custom(type);
        }
        if (userTypes != null && (userType = userTypes.get(Metadata.handleId(type))) != null) {
            return userType;
        }
        return new UnresolvedUserType(keyspace, type, cluster);
    }

    private static class Parser {
        private final String str;
        private int idx;

        Parser(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        String parseTypeName() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            return this.readNextIdentifier();
        }

        List<String> parseTypeParameters() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isEOS()) {
                return list;
            }
            this.skipBlankAndComma();
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == '>') {
                    ++this.idx;
                    return list;
                }
                try {
                    String name = this.parseTypeName();
                    String args = this.readRawTypeParameters();
                    list.add(name + args);
                }
                catch (DriverInternalError e) {
                    DriverInternalError ex = new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private String readNextIdentifier() {
            int i = this.idx;
            while (!this.isEOS() && (ParseUtils.isIdentifierChar(this.str.charAt(this.idx)) || this.str.charAt(this.idx) == '\"')) {
                ++this.idx;
            }
            return this.str.substring(i, this.idx);
        }

        private String readRawTypeParameters() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            if (this.isEOS() || this.str.charAt(this.idx) == '>' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '<' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open = 1;
            while (open > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed angle brackets");
                }
                if (this.str.charAt(this.idx) == '<') {
                    ++open;
                    continue;
                }
                if (this.str.charAt(this.idx) != '>') continue;
                --open;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!ParseUtils.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        private boolean isEOS() {
            return this.idx >= this.str.length();
        }

        public String toString() {
            return this.str.substring(0, this.idx) + "[" + (this.idx == this.str.length() ? "" : Character.valueOf(this.str.charAt(this.idx))) + "]" + this.str.substring(this.idx + 1);
        }
    }
}

