/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmappedSegmentedFile
extends SegmentedFile {
    private static final Logger logger = LoggerFactory.getLogger(MmappedSegmentedFile.class);
    private final MmappedRegions regions;

    public MmappedSegmentedFile(ChannelProxy channel, int bufferSize, long length, MmappedRegions regions) {
        super(new Cleanup(channel, regions), channel, bufferSize, length);
        this.regions = regions;
    }

    private MmappedSegmentedFile(MmappedSegmentedFile copy) {
        super(copy);
        this.regions = copy.regions;
    }

    @Override
    public MmappedSegmentedFile sharedCopy() {
        return new MmappedSegmentedFile(this);
    }

    @Override
    public RandomAccessReader createReader() {
        return new RandomAccessReader.Builder(this.channel).overrideLength(this.length).regions(this.regions).build();
    }

    @Override
    public RandomAccessReader createReader(RateLimiter limiter) {
        return new RandomAccessReader.Builder(this.channel).overrideLength(this.length).bufferSize(this.bufferSize).regions(this.regions).limiter(limiter).build();
    }

    static class Builder
    extends SegmentedFile.Builder {
        private MmappedRegions regions;

        Builder() {
        }

        @Override
        public SegmentedFile complete(ChannelProxy channel, int bufferSize, long overrideLength) {
            long length = overrideLength > 0L ? overrideLength : channel.size();
            this.updateRegions(channel, length);
            return new MmappedSegmentedFile(channel, bufferSize, length, this.regions.sharedCopy());
        }

        private void updateRegions(ChannelProxy channel, long length) {
            if (this.regions != null && !this.regions.isValid(channel)) {
                Throwable err = this.regions.close(null);
                if (err != null) {
                    logger.error("Failed to close mapped regions", err);
                }
                this.regions = null;
            }
            if (this.regions == null) {
                this.regions = MmappedRegions.map(channel, length);
            } else {
                this.regions.extend(length);
            }
        }

        @Override
        public void serializeBounds(DataOutput out, Version version) throws IOException {
            if (!version.hasBoundaries()) {
                return;
            }
            super.serializeBounds(out, version);
            out.writeInt(0);
        }

        @Override
        public void deserializeBounds(DataInput in, Version version) throws IOException {
            if (!version.hasBoundaries()) {
                return;
            }
            super.deserializeBounds(in, version);
            in.skipBytes(in.readInt() * TypeSizes.sizeof((long)0L));
        }

        @Override
        public Throwable close(Throwable accumulate) {
            return super.close(this.regions == null ? accumulate : this.regions.close(accumulate));
        }
    }

    private static final class Cleanup
    extends SegmentedFile.Cleanup {
        private final MmappedRegions regions;

        Cleanup(ChannelProxy channel, MmappedRegions regions) {
            super(channel);
            this.regions = regions;
        }

        @Override
        public void tidy() {
            Throwable err = this.regions.close(null);
            if (err != null) {
                JVMStabilityInspector.inspectThrowable((Throwable)err);
                logger.error("Error while closing mmapped regions", err);
            }
            super.tidy();
        }
    }
}

