/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.util.MultiPrintStream;

public class SettingsLog
implements Serializable {
    public final boolean noSummary;
    public final File file;
    public final int intervalMillis;
    public final Level level;

    public SettingsLog(Options options) {
        this.noSummary = options.noSummmary.setByUser();
        this.file = options.outputFile.setByUser() ? new File(options.outputFile.value()) : null;
        String interval = options.interval.value();
        this.intervalMillis = interval.endsWith("ms") ? Integer.parseInt(interval.substring(0, interval.length() - 2)) : (interval.endsWith("s") ? 1000 * Integer.parseInt(interval.substring(0, interval.length() - 1)) : 1000 * Integer.parseInt(interval));
        if (this.intervalMillis <= 0) {
            throw new IllegalArgumentException("Log interval must be greater than zero");
        }
        this.level = Level.valueOf(options.level.value().toUpperCase());
    }

    public MultiPrintStream getOutput() throws FileNotFoundException {
        MultiPrintStream stream = new MultiPrintStream(new PrintStream(System.out));
        if (this.file != null) {
            stream.addStream(new PrintStream(this.file));
        }
        return stream;
    }

    public static SettingsLog get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-log");
        if (params == null) {
            return new SettingsLog(new Options());
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsLog.printHelp();
            System.out.println("Invalid -log options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsLog((Options)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-log", new Options());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsLog.printHelp();
            }
        };
    }

    public static final class Options
    extends GroupedOptions {
        final OptionSimple noSummmary = new OptionSimple("no-summary", "", null, "Disable printing of aggregate statistics at the end of a test", false);
        final OptionSimple outputFile = new OptionSimple("file=", ".*", null, "Log to a file", false);
        final OptionSimple interval = new OptionSimple("interval=", "[0-9]+(ms|s|)", "1s", "Log progress every <value> seconds or milliseconds", false);
        final OptionSimple level = new OptionSimple("level=", "(minimal|normal|verbose)", "normal", "Logging level (minimal, normal or verbose)", false);

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.level, this.noSummmary, this.outputFile, this.interval);
        }
    }

    public static enum Level {
        MINIMAL,
        NORMAL,
        VERBOSE;

    }
}

