/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;

public class SettingsGraph
implements Serializable {
    public final String file;
    public final String revision;
    public final String title;
    public final String operation;
    public final File temporaryLogFile;

    public SettingsGraph(GraphOptions options, SettingsCommand stressCommand) {
        this.file = options.file.value();
        this.revision = options.revision.value();
        this.title = options.revision.value() == null ? "cassandra-stress - " + new SimpleDateFormat("yyyy-mm-dd hh:mm:ss").format(new Date()) : options.title.value();
        String string = this.operation = options.operation.value() == null ? stressCommand.type.name() : options.operation.value();
        if (this.inGraphMode()) {
            try {
                this.temporaryLogFile = File.createTempFile("cassandra-stress", ".log");
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot open temporary file");
            }
        } else {
            this.temporaryLogFile = null;
        }
    }

    public boolean inGraphMode() {
        return this.file != null;
    }

    public static SettingsGraph get(Map<String, String[]> clArgs, SettingsCommand stressCommand) {
        String[] params = clArgs.remove("-graph");
        if (params == null) {
            return new SettingsGraph(new GraphOptions(), stressCommand);
        }
        GraphOptions options = (GraphOptions)GroupedOptions.select((String[])params, (GroupedOptions[])new GraphOptions[]{new GraphOptions()});
        if (options == null) {
            SettingsGraph.printHelp();
            System.out.println("Invalid -graph options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsGraph(options, stressCommand);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-graph", new GraphOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsGraph.printHelp();
            }
        };
    }

    private static final class GraphOptions
    extends GroupedOptions {
        final OptionSimple file = new OptionSimple("file=", ".*", null, "HTML file to create or append to", true);
        final OptionSimple revision = new OptionSimple("revision=", ".*", "unknown", "Unique name to assign to the current configuration being stressed", false);
        final OptionSimple title = new OptionSimple("title=", ".*", null, "Title for chart (current date by default)", false);
        final OptionSimple operation = new OptionSimple("op=", ".*", null, "Alternative name for current operation (stress op name used by default)", false);

        private GraphOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.file, this.revision, this.title, this.operation);
        }
    }
}

