# @copyright (c) 2002-2016 Acronis International GmbH. All rights reserved.
# EULA: https://www.acronis.com/en-us/download/docs/eula/corporate/
# encoding: utf-8
from __future__ import absolute_import, print_function
from setuptools import setup, find_packages
import fes as module

requires = [
    'asyncio',
    'construct==2.5.2',
]


setup(
    name=module.__name__,
    version=module.__version__,
    author=module.__author__,
    author_email=module.team_email,
    license=module.license,
    description=module.package_info,
    platforms="all",
    classifiers=(
        'License :: Other/Proprietary License',
        'Natural Language :: English',
        'Operating System :: MacOS',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3 :: Only',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: Implementation :: CPython',
        'Topic :: Internet',
        'Topic :: Software Development :: Libraries',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Software Development',
    ),
    long_description=open('README.rst').read(),
    packages=find_packages(exclude=('tests','examples',)),
    install_requires=requires,
)
