# @copyright (c) 2002-2016 Acronis International GmbH. All rights reserved.
# EULA: https://www.acronis.com/en-us/download/docs/eula/corporate/

from __future__ import print_function
try:
    from urllib.parse import urlparse
except ImportError:
    from six.moves.urllib.parse import urlparse
from acronis.lib import axmlrpc
import logging


def check_response_status(response):
    response = response.read()
    logging.debug('RPC response: %s', response)
    response = axmlrpc.loads(response)
    status = response['Status']
    if status.upper() != 'OK':
        raise axmlrpc.Error(status, response['Description'])
    return response['Data']

def decode_plain_response(response):
    return response

def decode_redirect_response(response):
    url = response['Url']
    parseResult = urlparse(url)
    address = parseResult.scheme + '://' + parseResult.netloc
    query = parseResult.query
    host, _, port = address.rpartition(':')
    host = host.replace('https://', '', 1).replace('http://', '', 1)
    cipher = query.replace('cipher=', '', 1)
    result = {'URL': url, 'Address': address, 'Query': query, 'Host': host, 'Port': port, 'Cipher': cipher}
    if 'BrandId' in response:
        result['BrandId'] = int(response['BrandId'])
    if 'AccountId' in response:
        result['AccountId'] = int(response['AccountId'])
    return result

def decode_checkAccount_response(response):
    return response['SessionId']

def decode_getUsedSpace_response(response):
    return response['UsedStorageSize']

def decode_token_response(response):
    return response['Token']

def decode_getSubaccountsList_response(response):
    subaccounts = response['Subaccounts']
    if not isinstance(subaccounts, list):
        subaccounts = [subaccounts]
    return [subaccount['Subaccount']['id'] for subaccount in subaccounts]

def decode_registrations_response(response):
    registrations = response['Registrations']
    if not isinstance(registrations, list):
        registrations = [registrations]
    return [registration['Registration'] for registration in registrations]
