# @copyright (c) 2002-2016 Acronis International GmbH. All rights reserved.
# EULA: https://www.acronis.com/en-us/download/docs/eula/corporate/

from configparser import ConfigParser


def add_section_header(file, header_name):
    yield '[{}]\n'.format(header_name)
    for line in file:
        yield line

def parse(file_name):
    cp = ConfigParser()
    cp.read_file(add_section_header(open(file_name), 'fake_section'))
    return dict(cp.items('fake_section'))

if __name__ == "__main__":
    from sys import argv
    print(parse(argv[1]))
