#!/usr/bin/env python
# @copyright (c) 2002-2016 Acronis International GmbH. All rights reserved.
# EULA: https://www.acronis.com/en-us/download/docs/eula/corporate/

import os
import sys
import subprocess
import xml.etree.ElementTree as ET
from is_lsr import is_tool_path


def process_meta(path):
    if os.path.isdir(path):
        result = subprocess.check_output([is_tool_path(), '--parameters', '--vault', path])
    elif os.path.isfile(path):
        result = subprocess.check_output([is_tool_path(), '--parameters', '--file', path])
    else:
        sys.exit('File or directory {0} is not found.'.format(path))

    return ET.fromstring(result)


def main(args):
    try:
        xml = process_meta(args.path)
        print('User account: ' + xml.get('account_id', ''))
        print('Subaccount: ' + xml.get('subaccount_id', ''))
        print('Session: ' + xml.get('session_id', ''))
        print('Token: ' + xml.get('token', ''))
    except subprocess.CalledProcessError as e:
        sys.exit(e.returncode)


def parse_arguments():
    from argparse import ArgumentParser
    parser = ArgumentParser(add_help=True, description='Displays service information about an Initial Seeding backup.')
    parser.add_argument('path', metavar='<path>', help='path to an IS backup or the .TIB file')
    # exit code 2
    return parser.parse_args()


if __name__ == "__main__":
    main(parse_arguments())
